/**
 *  The package contains classes for JIDE Feed Reader product.
 */
package com.jidesoft.rss;


/**
 *  The main component for <code>FeedReader</code>.
 */
public class FeedReader extends javax.swing.JPanel implements FeedEventListener {

	/**
	 *  The logger name for the logger used by <code>FeedReader</code>.
	 */
	public static String LOGGER_NAME;

	/**
	 *  The logger name for the logger used by <code>FeedReader</code> to log <code>FeedEvent</code>s.
	 */
	public static String EVENT_LOGGER_NAME;

	/**
	 *  A list of event listeners for this component.
	 */
	protected javax.swing.event.EventListenerList listenerList;

	/**
	 *  Creates a <code>FeedReader</code> using the default FeedDatabasePersistenceLayer.
	 */
	public FeedReader() {
	}

	public FeedReader(String localFolder) {
	}

	/**
	 *  Creates a <code>FeedReader</code> using the default FeedDatabasePersistenceLayer with an array of default
	 *  channels.
	 * 
	 *  @param defaultChannels the default channels. Those channels will be there when user runs for the first time.
	 */
	public FeedReader(String[] defaultChannels) {
	}

	/**
	 *  @param defaultChannels        the default channels. Those channels will be there when user runs for the first
	 *                                time.
	 *  @param defaultSelectedChannel the default selected channel when FeedReader is created.
	 */
	public FeedReader(String[] defaultChannels, String defaultSelectedChannel) {
	}

	public FeedReader(String[] defaultChannels, boolean allowGroup) {
	}

	public FeedReader(String localFolder, String[] defaultChannels) {
	}

	public FeedReader(String localFolder, String[] defaultChannels, String defaultSelectedChannel) {
	}

	public FeedReader(String[] defaultChannels, String localFolder, boolean allowGroup) {
	}

	public FeedReader(PersistenceManagerIF layer, FeedPreference preference, boolean allowGroup, String localFolder, String[] defaultChannels) {
	}

	public FeedReader(PersistenceManagerIF layer, FeedPreference preference, boolean allowGroup, String localFolder, String[] defaultChannels, String defaultSelectedChannel) {
	}

	/**
	 *  Creates the <code>FeedPreference</code>. By default, we will create <code>DefaultFeedPreference</code> which uses
	 *  java.utils.pref to save the data.
	 * 
	 *  @return FeedPreference.
	 */
	protected FeedPreference createFeedPreference() {
	}

	/**
	 *  Gets the title of the component.
	 * 
	 *  @return the title of the component.
	 */
	public String getTitle() {
	}

	public void initialize() {
	}

	/**
	 *  Layout the major panels.
	 * 
	 *  @param toolBar     the tool bar component
	 *  @param channelPane the channel list component
	 *  @param itemPane    the item table component
	 *  @param browserPane the browser component
	 *  @return the container contains all the major panels.
	 */
	protected javax.swing.JComponent layoutComponents(java.awt.Component toolBar, java.awt.Component channelPane, java.awt.Component itemPane, java.awt.Component browserPane) {
	}

	/**
	 *  Dispose the component especially the persistence layer.
	 */
	public void dispose() {
	}

	/**
	 *  Gets the default channel that is selected when FeedReader created.
	 * 
	 *  @return the default selected channel.
	 */
	public String getDefaultSelectedChannel() {
	}

	public void eventHappened(FeedEvent e) {
	}

	/**
	 *  Creates the link label appears below the html browser. By default, it is actually a JideButton with
	 *  HYPERLINK_STYLE, not a JLabel.
	 * 
	 *  @return the link label appears below the html browser.
	 */
	protected java.awt.Component createEditorLinkLabel() {
	}

	/**
	 *  Creates the title label appears above the html browser.
	 * 
	 *  @return the title label appears above the html browser.
	 */
	protected java.awt.Component createEditorTitleLabel() {
	}

	protected javax.swing.JComponent createScrollPaneForHtmlBrowser(java.awt.Component browser) {
	}

	/**
	 *  Creates the html browser. Subclass can override this method to provide your own html browser. If so, you should
	 *  also override {@link #clearHtmlBrowser()} and {@link #displayHtmlBrowser(String,ItemIF)} to clear and display the
	 *  html browser respectively.
	 * 
	 *  @return the html browser. By default, JEditorPane will be used.
	 */
	protected java.awt.Component createHtmlBrowser() {
	}

	/**
	 *  Clears the html browser. If you provide your own html browser using {@link #createHtmlBrowser()}, you should also
	 *  override this method to clear the content. You can call {@link #getEditor()},{@link
	 *  #getEditorTitleLabel()},{@link #getEditorLinkLabel()} to get the three components which display the content, the
	 *  title and the link respectively.
	 */
	protected void clearHtmlBrowser() {
	}

	public java.awt.Component getHtmlBrowser() {
	}

	/**
	 *  Displays the content in the html browser. If you provide your own html browser using {@link
	 *  #createHtmlBrowser()}, you should also override this method to display the content. You can call {@link
	 *  #getEditor()},{@link #getEditorTitleLabel()},{@link #getEditorLinkLabel()} to get the three components which
	 *  display the content, the title and the link respectively.
	 * 
	 *  @param content the html content.
	 *  @param item    the feed item
	 */
	protected void displayHtmlBrowser(String content, ItemIF item) {
	}

	/**
	 *  Customizes the tree used for the channels.
	 * 
	 *  @param tree the channel tree.
	 */
	protected void customizeChannelTree(javax.swing.JTree tree) {
	}

	/**
	 *  Creates a JTree for the channel tree.
	 * 
	 *  @param model TreeModel.
	 *  @return a JTree
	 */
	protected javax.swing.JTree createChannelTree(javax.swing.tree.TreeModel model) {
	}

	/**
	 *  Creates the tool bar component. By default, it contains five buttons.
	 * 
	 *  @return the tool bar component.
	 */
	protected javax.swing.JComponent createToolBarComponent() {
	}

	/**
	 *  Creates the button that will be used on the toolbar.
	 * 
	 *  @param action the action for the button.
	 *  @return the button.
	 */
	protected javax.swing.AbstractButton createToolBarButton(javax.swing.AbstractAction action) {
	}

	/**
	 *  Creates the popup menu when user right clicks on a feed item.
	 * 
	 *  @return the popup menu for the feed item.
	 */
	protected javax.swing.JPopupMenu createItemPopupMenu() {
	}

	/**
	 *  Creates the popup menu when user right clicks on a channel.
	 * 
	 *  @return the popup menu for the channel.
	 */
	protected javax.swing.JPopupMenu createChannelPopupMenu() {
	}

	/**
	 *  Gets the tree containing the channels.
	 * 
	 *  @return the tree containing the channels.
	 */
	public javax.swing.JTree getFeedTree() {
	}

	/**
	 *  Gets the popup menu for the channel.
	 * 
	 *  @return the popup menu for the channel.
	 */
	public javax.swing.JPopupMenu getChannelPopupMenu() {
	}

	/**
	 *  Gets the popup menu for the feed item.
	 * 
	 *  @return the popup menu for the feed item.
	 */
	public javax.swing.JPopupMenu getItemPopupMenu() {
	}

	/**
	 *  Gets the table that contains the feeds from a channel.
	 * 
	 *  @return the table that contains the feeds from a channel.
	 */
	public javax.swing.JTable getFeedTable() {
	}

	public java.awt.Component getEditor() {
	}

	public java.awt.Component getEditorLinkLabel() {
	}

	public java.awt.Component getEditorTitleLabel() {
	}

	/**
	 *  Gets the image icon. All names are defined in {@link com.jidesoft.rss.FeedIconsFactory}. Subclass can override
	 *  this method to provide your own icons.
	 * 
	 *  @param name the icon name.
	 *  @return the image icon.
	 */
	protected javax.swing.ImageIcon getImageIcon(String name) {
	}

	/**
	 *  Gets the localized string from resource bundle. Subclass can override it to provide its own string. Available
	 *  keys are defined in dashboard.properties.
	 * 
	 *  @param key the resource key.
	 *  @return the localized string.
	 */
	protected String getResourceString(String key) {
	}

	/**
	 *  Gets the resource bundle used by this component.
	 * 
	 *  @return the resource bundle.
	 */
	public java.util.ResourceBundle getResourceBundle() {
	}

	/**
	 *  Sets the <code>FeedPersistenceLayer</code>.
	 * 
	 *  @param layer the <code>FeedPersistenceLayer</code>.
	 */
	public void setFeedPersistenceManager(PersistenceManagerIF layer) {
	}

	/**
	 *  Gets the <code>FeedPersistenceLayer</code>.
	 * 
	 *  @return the <code>FeedPersistenceLayer</code>.
	 */
	public PersistenceManagerIF getFeedPersistenceManager() {
	}

	/**
	 *  Adds <code>FeedEventListener</code> to listen to <code>FeedEvent</code>.
	 * 
	 *  @param eventListener the <code>FeedEventListener</code> to be added.
	 */
	public void addFeedEventListener(FeedEventListener eventListener) {
	}

	/**
	 *  Removes the <code>FeedEventListener</code> that was added before.
	 * 
	 *  @param eventListener the <code>FeedEventListener</code>.
	 */
	public void removeFeedEventListener(FeedEventListener eventListener) {
	}

	/**
	 *  Gets the registered <code>FeedEventListener</code>s.
	 * 
	 *  @return an array of <code>FeedEventListener</code>s.
	 */
	public FeedEventListener[] getFeedEventListeners() {
	}

	/**
	 *  Fires status changed event. The event id must be STATUS_CHANGED which it is set internally.
	 * 
	 *  @param message the message.
	 */
	public void fireStatusChangedEvent(String message) {
	}

	/**
	 *  Fires channel event. The event id could be CHANNEL_ADDED, CHANNEL_REMOVED, CHANNEL_CHANGED, CHANNEL_CLEARED or
	 *  CHANNEL_RELOADED.
	 * 
	 *  @param id      the event id.
	 *  @param channel the channel
	 */
	public void fireChannelEvent(int id, ChannelIF channel) {
	}

	/**
	 *  Fires CHANNEL_MOVED event.
	 * 
	 *  @param channel      the channel is moved
	 *  @param channelGroup the group where the channel is moved.
	 */
	public void fireChannelMovedEvent(ChannelIF channel, ChannelGroupIF channelGroup) {
	}

	/**
	 *  Fires channel event. The event id could be GROUP_ADDED, GROUP_REMOVED, and GROUP_CHANGED.
	 * 
	 *  @param id    the event id.
	 *  @param group the group
	 */
	public void fireGroupEvent(int id, ChannelGroupIF group) {
	}

	/**
	 *  Fires a feed event that the preference is changed. The event id must be PREFERENCE_CHANGED which it is set
	 *  internally.
	 * 
	 *  @param preference the <code>FeedPreference</code>.
	 */
	public void firePreferenceChangedEvent(FeedPreference preference) {
	}

	/**
	 *  Fires a feed event that the item read status changed. The event is must be ITEM_CHANGED. If the item parameter is
	 *  null, it means all items are affected.
	 * 
	 *  @param id   the vent id.
	 *  @param item the feed item.
	 */
	public void fireChannelItemEvent(int id, ItemIF item) {
	}

	/**
	 *  Fires a generic feed event.
	 * 
	 *  @param event the feed event.
	 */
	public void fireFeedEvent(FeedEvent event) {
	}

	/**
	 *  Makes the selected channel all items as read or unread.
	 * 
	 *  @param read true to make all items read. False to make unread.
	 */
	public void makeSelectedChannelRead(boolean read) {
	}

	/**
	 *  Toggles the selected feed item read status.
	 */
	public void toggleSelectedItemReadStatus() {
	}

	/**
	 *  Opens the feed item in external web browser.
	 */
	public void openItemInBrowser() {
	}

	/**
	 *  Opens the URL in the web browser configured in the FeedPreference.
	 * 
	 *  @param url the URL.
	 */
	public void openInBrowser(String url) {
	}

	/**
	 *  Opens the channel in external web browser.
	 */
	public void openChannelInBrowser() {
	}

	/**
	 *  Removes the selected channel.
	 */
	public void removeSelectedChannel() {
	}

	/**
	 *  Opens the selected channel.
	 */
	public void openSelectedChannel() {
	}

	/**
	 *  Opens the selected feed item in content preview panel.
	 */
	public void openSelectedItem() {
	}

	public void clearSelectedChannelHistory() {
	}

	/**
	 *  Reloads the selected channel.
	 */
	public void reloadSelectedChannel() {
	}

	/**
	 *  Reloads the channel. A new ChannelIF will be created after reloading. So this method will return the new instance
	 *  for you to use.
	 * 
	 *  @param channel the channel to be reloaded
	 *  @return the new channel.
	 */
	public ChannelIF reloadChannel(ChannelIF channel) {
	}

	public void addChannelGroup(String groupName) {
	}

	/**
	 *  Reloads the specified channel in the feed table.
	 * 
	 *  @param channel the channel to be reloaded.
	 */
	public void loadChannelInTable(ChannelIF channel) {
	}

	/**
	 *  Uses a dialog to edit the channel property.
	 */
	public void updateSelectedChannel() {
	}

	/**
	 *  Removes the selected group.
	 */
	public void removeSelectedGroup() {
	}

	/**
	 *  Moves the selected channel to another group.
	 * 
	 *  @param destGroup the destination group.
	 */
	public void moveSelectedChannel(ChannelGroupIF destGroup) {
	}

	/**
	 *  Moves the channel to another group.
	 * 
	 *  @param channel   the channel to be moved.
	 *  @param destGroup the destination channel group.
	 */
	public void moveChannel(ChannelIF channel, ChannelGroupIF destGroup) {
	}

	/**
	 *  Sets the delay in ms between each refresh event.
	 * 
	 *  @param delay the delay in ms.
	 */
	public void setRefreshDelay(int delay) {
	}

	/**
	 *  Reloads all channels.
	 */
	public void reloadAllChannels() {
	}

	/**
	 *  Gets the total # of unread items.
	 * 
	 *  @return the total # of unread items from all channels.
	 */
	public int getUnReadItemCountForAllChannels() {
	}

	/**
	 *  Gets the default channels. Default channels will appear when user uses this feed reader for the first time.
	 * 
	 *  @return the default channels.
	 */
	public String[] getDefaultChannels() {
	}

	/**
	 *  Gets the logger used by FeedReader to log the error and warning message.
	 * 
	 *  @return the logger used by FeedReader.
	 */
	public static java.util.logging.Logger getLogger() {
	}

	public FeedPreference getFeedPreference() {
	}

	public boolean isAllowGroup() {
	}

	public String getUserDataPath() {
	}

	public String getUserIconPath() {
	}

	public void enableGroupActionMenu() {
	}

	public void enableChannelActionMenu() {
	}

	public void enableDefaultActionMenu() {
	}

	public javax.swing.JPopupMenu getGroupPopupMenu() {
	}

	@java.lang.SuppressWarnings("UnusedDeclaration")
	public javax.swing.ImageIcon getChannelIcon(ChannelIF channel) {
	}

	public void addChannel(String url) {
	}

	public void setMaxCacheItems(int maxItems) {
	}

	public int getMaxCacheItems() {
	}
}
