/**
 *  The package contains classes for JIDE Feed Reader product.
 */
package com.jidesoft.rss;


/**
 *  Event for <code>FeedReader</code>.
 */
public class FeedEvent extends java.util.EventObject {

	/**
	 *  The first event id.
	 */
	public static final int FEED_EVENT_FIRST = 12199;

	/**
	 *  A channel is added. {@link #getChannel()} will tell you the channel.
	 */
	public static final int CHANNEL_ADDED = 12199;

	/**
	 *  A channel's title is changed. {@link #getChannel()} will tell you the channel.
	 */
	public static final int CHANNEL_CHANGED = 12200;

	/**
	 *  A channel is removed. {@link #getChannel()} will tell you the channel.
	 */
	public static final int CHANNEL_REMOVED = 12201;

	/**
	 *  A channel is moved to another group. {@link #getChannel()} will tell you the channel.
	 */
	public static final int CHANNEL_MOVED = 12202;

	/**
	 *  A channel's history is cleared. {@link #getChannel()} will tell you the channel.
	 */
	public static final int CHANNEL_CLEARED = 12203;

	/**
	 *  A channel is reloaded. {@link #getChannel()} will tell you the channel.
	 */
	public static final int CHANNEL_RELOADED = 12204;

	/**
	 *  A group is added. {@link #getChannelGroup()} will tell you the group.
	 */
	public static final int GROUP_ADDED = 12205;

	/**
	 *  A group's title is changed. {@link #getChannelGroup()} will tell you the group.
	 */
	public static final int GROUP_CHANGED = 12206;

	/**
	 *  A group is removed. {@link #getChannelGroup()} will tell you the group.
	 */
	public static final int GROUP_REMOVED = 12207;

	/**
	 *  An item's read status is changed. {@link #getItem()} will tell you the item.
	 */
	public static final int ITEM_CHANGED = 12208;

	/**
	 *  The user preference is updated. {@link #getFeedPreference()} will tell you the current preference.
	 */
	public static final int PREFERENCE_CHANGED = 12209;

	/**
	 *  Status is updated. {@link #getMessage()} will tell you the message. You can listen to this event to get all
	 *  status updates so that you can display the message on the status bar if you have one.
	 */
	public static final int STATUS_CHANGED = 12210;

	public FeedEvent(Object source, int id) {
	}

	/**
	 *  Creates a FeedEvent about a change to the Channel.
	 * 
	 *  @param source  the source.
	 *  @param id      the event id
	 *  @param channel the channel that is added/removed/updated etc.
	 */
	public FeedEvent(Object source, int id, ChannelIF channel) {
	}

	/**
	 *  Creates a FeedEvent about a channel is moved to another channel.
	 * 
	 *  @param source       the source.
	 *  @param id           the event id
	 *  @param channel      the channel that is moved.
	 *  @param channelGroup the group where the channel is moved to.
	 */
	public FeedEvent(Object source, int id, ChannelIF channel, ChannelGroupIF channelGroup) {
	}

	/**
	 *  Creates a FeedEvent about a change to the group.
	 * 
	 *  @param source       the source.
	 *  @param id           the event id
	 *  @param channelGroup the group that is added/removed/updated etc.
	 */
	public FeedEvent(Object source, int id, ChannelGroupIF channelGroup) {
	}

	/**
	 *  Creates a FeedEvent to notify a status change. The id is always FeedEvent.STATUS_CHANGED.
	 * 
	 *  @param source   the source.
	 *  @param eventMsg the message.
	 */
	public FeedEvent(Object source, String eventMsg) {
	}

	/**
	 *  Creates a FeedEvent about a change to the item.
	 * 
	 *  @param source the source.
	 *  @param id     the event id
	 *  @param item   the item that is changed.
	 */
	public FeedEvent(Object source, int id, ItemIF item) {
	}

	/**
	 *  Creates a FeedEvent to notify FeedPreference is changed. The event id is always FeedEvent.PREFERENCE_CHANGED.
	 * 
	 *  @param source         the source.
	 *  @param feedPreference the new feed preference.
	 */
	public FeedEvent(Object source, FeedPreference feedPreference) {
	}

	public String getMessage() {
	}

	public ChannelIF getChannel() {
	}

	public ChannelGroupIF getChannelGroup() {
	}

	public int getID() {
	}

	public ItemIF getItem() {
	}

	public FeedPreference getFeedPreference() {
	}

	public String paramString() {
	}
}
