/**
 *  The package contains classes for JIDE Feed Reader product.
 */
package com.jidesoft.rss;


/**
 *  An implementation of <code>FeedPersistenceLayer</code> using hsqldb (http://hsqldb.org/). By default, it will take a
 *  local folder and create two subfolders. The "icon" subfolder is for channel icons. The "db" subfolder for hsqldb
 *  file.
 */
public class FeedDatabasePersistenceManager {

	public FeedDatabasePersistenceManager(FeedReader feedReader) {
	}

	public ChannelGroupIF createGroup(String title) {
	}

	public void updateGroup(ChannelGroupIF group) {
	}

	public void deleteGroup(ChannelGroupIF group) {
	}

	public void mergeGroups(ChannelGroupIF dstGroup, ChannelGroupIF srcGroup) {
	}

	public ChannelGroupIF[] getGroups() {
	}

	public ChannelIF createChannel(String title, java.net.URL url) {
	}

	public void updateChannel(ChannelIF channel) {
	}

	public void addChannelToGroup(ChannelIF channel, ChannelGroupIF group) {
	}

	public void removeChannelFromGroup(ChannelIF channel, ChannelGroupIF group) {
	}

	public void deleteChannel(ChannelIF channel) {
	}

	public ItemIF createItem(ChannelIF channel, String itemTitle) {
	}

	public ItemIF createItem(ChannelIF channel, ItemIF item) {
	}

	public void updateItem(ItemIF item) {
	}

	public void deleteItem(ItemIF item) {
	}

	/**
	 *  flush data, close the db.
	 * 
	 *  @throws Exception if any database access errors.
	 */
	public void close() {
	}

	/**
	 *  Initializes the database. By default, we will hsqldb. If the database file is not found, we will create it using
	 *  {@link #installDB(java.sql.Connection)} method.
	 * 
	 *  @return true if the database is used the first time.
	 * 
	 *  @throws Exception if any errors happen during the initialization such as the driver class not found or database
	 *                    access problem.
	 */
	protected boolean initializeDB() {
	}

	/**
	 *  Installs the database.
	 * 
	 *  @param connection the connection.
	 */
	protected void installDB(java.sql.Connection connection) {
	}

	/**
	 *  Gets the URL for rssdbscript.dll. You can override it if you provide your own database script in installDb
	 *  method. By default, we put rssdbscript.ddl at the same place as FeedReader.class so the code to get the URL for
	 *  it is FeedUtils.class.getResource(("rssdbscript.ddl")).
	 * 
	 *  @return the resource
	 */
	protected java.net.URL getScriptURL() {
	}

	/**
	 *  Gets the database connection. This connection is used by this class to update the database.
	 * 
	 *  @return the database connection.
	 */
	protected java.sql.Connection getConnection() {
	}

	/**
	 *  Gets the table name. The original table names can be CATEGORIES, CAT_CHANNEL_LINK, CAT_GROUP_CHANNEL,
	 *  CAT_ITEM_LINK, CHANNELS, CHANNEL_GROUPS, CHANNEL_SUBSCRIPTIONS, CLOUDS, IMAGES, ITEMS, ITEM_ENCLOSURE, ITEM_GUID,
	 *  ITEM_METADATA, ITEM_SOURCE, TEXTINPUTS, and CONFIG. You can return different names here or you can override
	 *  {@link #getTablePrefix()} or {@link #getTablePostfix()} if you just want to add a prefix or postfix. However make
	 *  sure you change them in the rssdbscript.ddl file to match what you changed here.
	 * 
	 *  @param originalTableName the original table name
	 *  @return the new name after after adding the prefix and postfix if any.
	 */
	protected String getTableName(String originalTableName) {
	}

	/**
	 *  Gets the table name prefix. It is used by {@link #getTableName(String)} method.
	 * 
	 *  @return "" by default.
	 */
	protected String getTablePrefix() {
	}

	/**
	 *  Gets the table name postfix. It is used by {@link #getTableName(String)} method.
	 * 
	 *  @return "" by default.
	 */
	protected String getTablePostfix() {
	}

	/**
	 *  By default, this method will call connection.prepareStatement(sql) and return the returned value. We expose this
	 *  as a protected method is because some database systems might need to customize the sql string. In this case,
	 *  subclass can override it to customize it before calling connection.prepareStatement.
	 * 
	 *  @param connection the connection
	 *  @param sql        an SQL statement that may contain one or more '?' IN parameter placeholders
	 *  @return the PreparedStatement object for sending parametrized SQL statements to the database.
	 * 
	 *  @throws SQLException if a database access error occurs or this method is called on a closed connection
	 */
	protected java.sql.PreparedStatement prepareStatement(java.sql.Connection connection, String sql) {
	}
}
